function [N_r,J_r,L_r,H_r] = Attenuation_observer(A,B,F,D1,C,D2)

[n,m] = size(B);
[~,l] = size(F);
[~,q] = size(D1);
[p,~] = size(C);

% Augmented system
A_bar = [A F; zeros(l,n+l)]; 
B_bar = [B; zeros(l,m)]; 
D1_bar = [D1 zeros(n,l); zeros(l,q) eye(l)];
C_bar = [C zeros(p,l)];
D2_bar = [D2 zeros(p,l)];
Cs1 = 1.0e1*eye(n+l);

% Solving LMIs using the Matlab LMI toolbox
gamma = 9;

setlmis([])

Qs=lmivar(1, [n+l 1] );
Ms1=lmivar(2, [n+l p] );
Ms2=lmivar(2, [n+l p] );

% LMI1
lmiterm([ 1 1 1  Qs] , 1, A_bar, ' s');
lmiterm([ 1 1 1  Ms1] , -1, C_bar*A_bar, ' s');
lmiterm([ 1 1 1  Ms2] , -1, C_bar, ' s');

lmiterm([ 1 1 2  Qs] , 1, D1_bar);
lmiterm([ 1 1 2  Ms1] , -1, C_bar*D1_bar);
lmiterm([ 1 1 2  Ms2] , -1, D2_bar);
lmiterm([ 1 1 2  Ms1] , -1, D2_bar);
lmiterm([ 1 1 3  0] , Cs1' );

lmiterm([ 1 2 2  0] ,-gamma^2);
lmiterm([ 1 3 3 0] , -1);

%LMI2
lmiterm([-2 1 1  Qs], 1, 1);

lmisys = getlmis;

[ tmin,xfeas ] = feasp(lmisys);
Qs = dec2mat(lmisys, xfeas, Qs);
Ms1 = dec2mat(lmisys, xfeas, Ms1);
Ms2 = dec2mat(lmisys, xfeas, Ms2);


H_r = inv(Qs)*Ms1;
L1 = inv(Qs)*Ms2;

Xi = eye(n+l) - H_r*C_bar;
N_r = Xi*A_bar - L1*C_bar;
T_r = Xi;
J_r = Xi*B_bar;
L2 = N_r*H_r;
L_r = L1 + L2;
